 {{ Form::open(['url' => 'deal']) }}
 <div class="modal-body">
     <div class="row">
         <div class="form-group col-md-6">
             {{ Form::label('name', __('Deal Name'), ['class' => 'col-form-label']) }}
             {{ Form::text('name', null, ['class' => 'form-control', 'required' => 'required']) }}
         </div>
         <div class="form-group col-md-6">
             {{ Form::label('price', __('Price'), ['class' => 'col-form-label']) }}
             {{ Form::number('price', 0, ['class' => 'form-control', 'min' => 0]) }}
         </div>
         <div class="form-group col-md-6">
             {{ Form::label('clients', __('Advocates'), ['class' => 'col-form-label']) }}
             {{ Form::select('clients[]', $clients, null, ['class' => 'form-control multi-select', 'id' => 'choices-multiple', 'multiple' => '', 'required' => 'required']) }}
         </div>
         <div class="form-group col-md-6">
             {{ Form::label('phone_no', __('Phone No'), ['class' => 'col-form-label']) }}
             {{ Form::tel('phone_no', null, ['class' => 'form-control', 'required' => 'required']) }}
         </div>
     </div>
 </div>
 <div class="modal-footer pr-0">
     <button type="button" class="btn  btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
     {{ Form::submit(__('Create'), ['class' => 'btn  btn-primary']) }}
 </div>

 {{ Form::close() }}

 <script src="{{ asset('assets/js/plugins/choices.min.js') }}"></script>
 <script>
     if ($(".multi-select").length > 0) {
         $($(".multi-select")).each(function(index, element) {
             var id = $(element).attr('id');
             var multipleCancelButton = new Choices(
                 '#' + id, {
                     removeItemButton: true,
                 }
             );
         });
     }
 </script>
